/**Table: daily_cash_by_branch**/
select b.date,b.center_id,b.zone_id,b.branch_id,center.center_name,center.center_no,
sum(li.amount) as insurance_amount,
sum(llp.amount) as loan_loss_probation,
sum(ms.share_amount) as share_amount,
sum(ld.amount) as loan_amount_daily, 
sum(lw.amount) as loan_amount_weekly, 
sum(lm.amount) as loan_amount_monthly, 
sum(sd.amount) as saving_amount_daily, 
sum(sw.amount) as saving_amount_weekly,
sum(sm.amount) as saving_amount_month,

sum(d.amount) as dps_amount 
from balance b 
left join member_share as ms on (ms.share_id=b.share_id)
left join loan_loss_probation as llp on (llp.id=b.loan_loss_probation_id)
left join loan_insurance as li on (li.id=b.loan_insurance_id)

left join loan_transaction as ld on (ld.transaction_id=b.loan_transaction_id and b.account_type=1)
left join loan_transaction as lw on (lw.transaction_id=b.loan_transaction_id and b.account_type=2)
left join loan_transaction as lm on (lm.transaction_id=b.loan_transaction_id and b.account_type=3)

left join saving_account_transaction as sd on (sd.transaction_id=b.saving_transaction_id and sd.account_type=1 and sd.transaction_type=1)
left join saving_account_transaction as sw on (sw.transaction_id=b.saving_transaction_id and sw.account_type=2 and sw.transaction_type=1)
left join saving_account_transaction as sm on (sm.transaction_id=b.saving_transaction_id and sm.account_type=3 and sm.transaction_type=1)
left join dps_account_transaction  as d on (d.transaction_id=b.dps_transaction_id and d.transaction_type=1) 
left join center on center.center_id=b.center_id
group by b.date,b.branch_id,b.center_id 
having (
loan_amount_daily is not null
or loan_amount_weekly is not null
or loan_amount_monthly is not null
or saving_amount_daily is not null
or saving_amount_weekly is not null
or saving_amount_month is not null
or dps_amount is not null
or share_amount 
or insurance_amount is not null
or loan_loss_probation is not null
)






